%{
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"

#define YYPARSE_PARAM pars
#define YYLEX_PARAM pars


	static LINE *ln;
	static NEXT *nx;
	static FILE *fil = NULL;
	static LINE *onerror;
	static SUB *sub;
	static OPEN *o;
	static DATA *d;
	static DATA *current_data;
	static FUNC *fn;
	static int i;
	static int tab_pos = 0;
	static int option_s;
	static int option_d;
	static int option_l;
	static int option_r;
	static int dataptr;
	static short file_read = 0;
	static short file_write = 0;
	static char slask[1024];
	static char temp[1024];

%}


%union {
  double d;
  char s[1024];
  VARIABLE *v;
  VARLIST vl;
  EXPRLIST el;
  INTLIST il;
}

%token <d> NUM
%token <s> STRING
%token <s> NUMVAR
%token <s> STRINGVAR
%token <s> IDENTIFIER

%token LTEQ GTEQ NEQ

%token End For Next
%token <s> Data
%token Input Del Dim Read

%token Gr Text Pr In Call Plot Hlin Vlin
%token Hgr2 Hgr Hcolor Hplot Draw Xdraw Htab Home
%token Rot Scale Shload Trace Notrace Normal Inverse Flash
%token Color Pop Vtab Himem Lomem Onerr Resume Recall
%token Store Speed Let Goto Run If Restore Amper

%token Gosub Return
%token <s> Rem
%token Stop On Wait Load Save

%token Def Poke Print Cont List Clear Get New

%token <s> Tab
%token To Fn Spc Then At Not Step

%token And Or
%token Sgn Int Abs Usr Fre Scrn
%token Pdl Pos Sqr Rnd Log Exp Cos Sin
%token Tan Atn Peek Len Str Val Asc Chr
%token Left Right Mid

%left Or And 
%right Not
%left '<' '>' LTEQ GTEQ NEQ '='
%left '+' '-'
%left '*' '/' '^'
%left UNARYMINUS

%type <d> expr
%type <s> string_expr
%type <s> print_exprs
%type <v> variable
%type <v> string_variable
%type <vl> var_list
%type <el> expr_list
%type <il> int_list

%%

line:
	statement

statement:
	End
	{
		next_line = NULL;
	}
|
	For variable '=' expr To expr
	{
		for (nx = nextbase; nx; nx = nx -> next)
			if (nx -> ln == current_line)
			{
				removelist(&nextbase,nx);
				break;
			}
		if (!nx)
			nx = (NEXT *)malloc(sizeof(NEXT));
		nx -> ln = current_line;
		nx -> var = $2;
		$2 -> value = $4;
		nx -> tolimit = $6;
		nx -> step = 1;
		nx -> reline = next_line;
		nx -> next = nextbase;
		nextbase = nx;
#ifdef DEBUG
printf("%s\n",current_line -> the_str);
printf(" for %d:%d (%s = %d) .. %d\n",
 nx -> ln -> parent,
 nx -> ln -> child,
 nx -> var -> name,
 (int)nx -> var -> value,
 (int)nx -> tolimit);
#endif
	}
|
	For variable '=' expr To expr Step expr
	{
		for (nx = nextbase; nx; nx = nx -> next)
			if (nx -> ln == current_line)
			{
				removelist(&nextbase,nx);
				break;
			}
		if (!nx)
			nx = (NEXT *)malloc(sizeof(NEXT));
		nx -> ln = current_line;
		nx -> var = $2;
		$2 -> value = $4;
		nx -> tolimit = $6;
		nx -> step = $8;
		nx -> reline = next_line;
		nx -> next = nextbase;
		nextbase = nx;
	}
|
	Next
	{
		nx = nextbase;
		if (nx)
		{
#ifdef DEBUG
printf(" next %d:%d\n",nx -> ln -> parent,nx -> ln -> child);
#endif
		nx -> var -> value += nx -> step;
		if (nx -> step > 0)
		{
			if (nx -> var -> value > nx -> tolimit + nx -> step / 2)
			{
				nextbase = nx -> next;
				free(nx);
			}
			else
			{
				next_line = nx -> reline;
			}
		}
		else
		{
			if (nx -> var -> value < nx -> tolimit - nx -> step / 2)
			{
				nextbase = nx -> next;
				free(nx);
			}
			else
			{
				next_line = nx -> reline;
			}
		}
		} // if (nx)
	}
|
	Next var_list
	{
		nx = nextbase;
		i = 0; /* index in var_list */
		while (nx && i < $2.qty)
		{
#ifdef DEBUG
printf(" next %d:%d\n",nx -> ln -> parent,nx -> ln -> child);
#endif
			nx -> var -> value += nx -> step;
			if (nx -> step > 0)
			{
				if (nx -> var -> value > nx -> tolimit)
				{
					nextbase = nx -> next;
					free(nx);
					nx = nextbase;
				}
				else
				{
					next_line = nx -> reline;
					nx = NULL;
				}
			}
			else
			{
				if (nx -> var -> value < nx -> tolimit)
				{
					nextbase = nx -> next;
					free(nx);
					nx = nextbase;
				}
				else
				{
					next_line = nx -> reline;
					nx = NULL;
				}
			}
			i++; /* index in var_list */
		}
	}
|
	Data 
	{
#ifdef DEBUG
printf("Data '%s'\n",$1);
#endif
		if (!running)
		{
			d = (DATA *)malloc(sizeof(DATA));
			d -> line = current_line -> line;
			d -> data = (char *)malloc(strlen($1) + 1);
			strcpy(d -> data,$1);
			addlist(&database,d);
		}
	}
|
	Input var_list
	{
/* check for file ops */
		if (running)
		for (i = 0; i < $2.qty; i++)
		{
#ifdef DEBUG
printf(" * Input %d\n",i);
#endif
			if (fil && file_read)
			{
				file_input($2.var[i] -> svalue,1024);
			}
			else
			{
				*$2.var[i] -> svalue = '.';
				while ($2.var[i] -> svalue[0] == '.')
				{
					gets($2.var[i] -> svalue);
					if ($2.var[i] -> svalue[0] == '.')
					{
						chdir($2.var[i] -> svalue);
					}
				}
			}
			$2.var[i] -> value = atof($2.var[i] -> svalue);
		}
	}
|
	Input STRING ';' var_list
	{
/* check for file ops */
		if (running)
		{
			text_output($2);
			for (i = 0; i < $4.qty; i++)
			{
#ifdef DEBUG
printf(" * Input %d\n",i);
#endif
				if (fil && file_read)
					file_input($4.var[i] -> svalue,1024);
				else
					gets($4.var[i] -> svalue);
				$4.var[i] -> value = atof($4.var[i] -> svalue);
			}
		}
	}
|
	Del
|
	Dim var_list
	{
	}
|
	Read var_list
	{
		read_data(&$2);
	}
|
	Gr
|
	Text
|
	Htab expr
|
	Home
|
	Normal
|
	Inverse
|
	Flash
|
	Pop
	{
		if (!subbase)
		{
//			printf(" *** pop without gosub\n");
			next_line = onerror;
		}
		else
		{
			sub = subbase;
			subbase = sub -> next;
			free(sub);
		}
	}
|
	Vtab expr
|
	Onerr Goto NUM
	{
		onerror = NULL;
		for (ln = linebase; ln && !onerror; ln = ln -> next)
			if (ln -> line == $3)
				onerror = ln;
	}
|
	Speed expr
|
	Let variable '=' expr
	{
		$2 -> value = $4;
	}
|
	Let string_variable '=' string_expr
	{
		strcpy($2 -> svalue,$4);
	}
|
	variable '=' expr
	{
		$1 -> value = $3;
	}
|
	string_variable '=' string_expr
	{
		strcpy($1 -> svalue,$3);
	}
|
	Goto NUM
	{
		for (ln = linebase; ln; ln = ln -> next)
			if (ln -> line == (int)($2 + .01))
				break;
		if (!ln)
			printf("GOTO undefined line number: %d\n",(int)($2 + .01));
		next_line = ln;
	}
|
	If expr
	{
		if (!$2 && running)
		{
			while (next_line -> line == -1 && next_line -> next)
				next_line = next_line -> next;
		}
	}
|
	Then statement
|
	Then NUM
	{
		for (ln = linebase; ln; ln = ln -> next)
			if (ln -> line == (int)($2 + .01))
				break;
		if (!ln)
			printf("GOTO undefined line number: %d\n",(int)$2);
		next_line = ln;
	}
|
	Gosub NUM
	{
		for (ln = linebase; ln; ln = ln -> next)
			if (ln -> line == (int)$2)
				break;
		if (!ln)
			printf("GOSUB undefined line number: %d\n",(int)$2);
		sub = (SUB *)malloc(sizeof(SUB));
		sub -> returnline = next_line;
		sub -> next = subbase;
		subbase = sub;
		next_line = ln;
	}
|
	Return
	{
		if (!subbase)
		{
//			printf(" *** return without gosub\n");
			next_line = onerror;
		}
		else
		{
			sub = subbase;
			subbase = sub -> next;
			next_line = sub -> returnline;
			free(sub);
		}
	}
|
	Rem
	{
//		printf("Remark '%s'\n",$1);
	}
|
	Stop
|
	On expr Goto int_list
	{
#ifdef DEBUG
printf(" ON %d GOTO ...\n",(int)$2);
#endif
		if ( (int)$2 > 0 && (int)$2 <= $4.qty)
		{
			for (ln = linebase; ln; ln = ln -> next)
				if (ln -> line == $4.values[(int)$2 - 1])
					break;
			if (!ln && running)
				printf("ON ... GOTO undefined line number: %d\n",(int)$2);
			next_line = ln;
		}
		else
		{
			if (running)
				printf("ON ... GOTO outside bounds\n");
			next_line = NULL;
		}
	}
|
	Def Fn IDENTIFIER '(' IDENTIFIER ')' '=' expr
	{
		for (fn = funcbase; fn; fn = fn -> next)
			if (!strcmp(fn -> name,$3))
				break;
		if (!fn)
		{
			fn = (FUNC *)malloc(sizeof(FUNC));
			strcpy(fn -> name,$3);
			addlist(&funcbase,fn);
		}
		sprintf(temp,"%s",$5);
		fn -> placeholder = reg_variable(temp,NULL);
		fn -> fnline = current_line;
	}
|
	Poke expr ',' expr
|
	Print
	{
		strcpy(temp,"\n");
		text_output(temp);
		tab_pos = 0;
	}
|
	Print print_exprs
	{
		sprintf(temp,"%s\n",$2);
		text_output(temp);
		tab_pos = 0;
	}
|
	Print print_exprs ';'
	{
		text_output($2);
		tab_pos = strlen($2);
	}
|
	Get string_variable
	{
		if (running)
		{
			if (fil && file_read)
			{
				fread($2 -> svalue,1,1,fil);
			}
			else
			{
				*$2 -> svalue = '.';
				while ($2 -> svalue[0] == '.')
				{
					gets($2 -> svalue);
					if ($2 -> svalue[0] == '.')
					{
						chdir($2 -> svalue);
					}
				}
			}
			$2 -> svalue[1] = 0;
		}
	}


expr_list:
	expr
	{
		$$.qty = 0;
		$$.values[$$.qty++] = $1;
	}
|
	expr_list ',' expr
	{
		$$ = $1;
		$$.values[$$.qty++] = $3;
	}

print_exprs:
	expr
	{
		sprintf(slask,"%f",$1);
		while (slask[strlen(slask) - 1] == '0')
			slask[strlen(slask) - 1] = 0;
		if (slask[strlen(slask) - 1] == '.')
			slask[strlen(slask) - 1] = 0;
		strcpy($$,slask);
		tab_pos = strlen($$);
	}
|
	string_expr
	{
		strcpy($$,$1);
		tab_pos = strlen($$);
	}
|
	print_exprs STRING
	{
		sprintf($$,"%s%s",$1,$2);
		tab_pos = strlen($$);
	}
|
	print_exprs ';' expr
	{
		sprintf(slask,"%f",$3);
		while (slask[strlen(slask) - 1] == '0')
			slask[strlen(slask) - 1] = 0;
		if (slask[strlen(slask) - 1] == '.')
			slask[strlen(slask) - 1] = 0;
		sprintf($$,"%s%s",$1,slask);
		tab_pos = strlen($$);
	}
|
	print_exprs ';' string_expr
	{
		sprintf($$,"%s%s",$1,$3);
		tab_pos = strlen($$);
	}
|
	print_exprs ',' expr
	{
		sprintf(slask,"%f",$3);
		while (slask[strlen(slask) - 1] == '0')
			slask[strlen(slask) - 1] = 0;
		if (slask[strlen(slask) - 1] == '.')
			slask[strlen(slask) - 1] = 0;
		sprintf($$,"%s%s",$1,slask);
		tab_pos = strlen($$);
	}
|
	print_exprs ',' string_expr
	{
		sprintf($$,"%s%s",$1,$3);
		tab_pos = strlen($$);
	}


expr:
	NUM
	{
#ifdef DEBUGEXPR
printf(" *-* expr: NUM(%.1f)\n",$1);
#endif
		$$ = $1;
	}
|
	variable
	{
#ifdef DEBUGEXPR
printf(" *-* expr: variable(%s)\n",$1 -> name);
#endif
		$$ = $1 -> value;
	}
|
	'-' expr %prec UNARYMINUS
	{
#ifdef DEBUGEXPR
printf(" *-* expr: - expr\n");
#endif
		$$ = -$2;
	}
|
	expr '+' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr + expr\n");
#endif
		$$ = $1 + $3;
	}
|
	expr '-' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr - expr\n");
#endif
		$$ = $1 - $3;
	}
|
	expr '*' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr * expr\n");
#endif
		$$ = $1 * $3;
	}
|
	expr '/' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr / expr\n");
#endif
		$$ = $1 / $3;
	}
|
	expr '<' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr < expr\n");
#endif
		$$ = $1 < $3;
	}
|
	expr '>' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr > expr\n");
#endif
		$$ = $1 > $3;
	}
|
	expr LTEQ expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr <= expr\n");
#endif
		$$ = $1 <= $3;
	}
|
	expr GTEQ expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr >= expr\n");
#endif
		$$ = $1 >= $3;
	}
|
	expr NEQ expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr != expr\n");
#endif
		$$ = $1 != $3;
	}
|
	expr '=' expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr == expr\n");
#endif
		$$ = $1 == $3;
	}
|
	string_expr '<' string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr < string_expr\n");
#endif
		$$ = (strcmp($1,$3) < 0) ? 1 : 0;
	}
|
	string_expr '>' string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr > string_expr\n");
#endif
		$$ = (strcmp($1,$3) > 0) ? 1 : 0;
	}
|
	string_expr LTEQ string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr <= string_expr\n");
#endif
		$$ = (strcmp($1,$3) <= 0) ? 1 : 0;
	}
|
	string_expr GTEQ string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr >= string_expr\n");
#endif
		$$ = (strcmp($1,$3) >= 0) ? 1 : 0;
	}
|
	string_expr NEQ string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr != string_expr\n");
#endif
		$$ = strcmp($1,$3) ? 1 : 0;
	}
|
	string_expr '=' string_expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: string_expr == string_expr\n");
#endif
		$$ = !strcmp($1,$3);
	}
|
	expr Or expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr || expr\n");
#endif
		$$ = $1 || $3;
	}
|
	expr And expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: expr && expr\n");
#endif
		$$ = $1 && $3;
	}
|
	Abs '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: ABS(expr)\n");
#endif
		if ($3 < 0)
			$$ = -$3;
		else
			$$ = $3;
	}
|
	Asc '(' string_expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: ASC(string_expr)\n");
#endif
		$$ = *$3;
	}
|
	Atn '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: ATN(expr)\n");
#endif
		$$ = atan($3);
	}
|
	Int '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: INT(expr)\n");
#endif
		$$ = (long)$3;
	}
|
	Val '(' string_expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: VAL(string_expr)\n");
#endif
		$$ = atof($3);
	}
|
	Rnd '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: RND(expr)\n");
#endif
		$$ = (double)rand();
		$$ /= RAND_MAX;
	}
|
	'(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: (expr)\n");
#endif
		$$ = $2;
	}
|
	Not expr
	{
#ifdef DEBUGEXPR
printf(" *-* expr: NOT expr\n");
#endif
		$$ = !$2;
	}
|
	Fn IDENTIFIER '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: FN ... ( expr )\n");
#endif
//printf("LINE: '%s'\n",the_str);
//printf("REST: '%s'\n",the_str + the_ptr);
		for (fn = funcbase; fn; fn = fn -> next)
			if (!strcmp(fn -> name,$2))
				break;
		if (fn)
		{
			fn -> placeholder -> fnvalue = fn -> placeholder -> value;
			fn -> placeholder -> value = $4;
			placeholder = fn -> placeholder;
			i = 0;
#define FC fn -> fnline -> the_str[i]
			while (FC && FC != '=')
				i++;
			if (FC == '=')
			{
//printf("BEFORE: '%s'\n",the_str);
				sprintf(temp,"*%s%s",fn -> fnline -> the_str + i + 1,the_str + the_ptr);
				strcpy(the_str + the_ptr,temp);
//printf(" AFTER: '%s'\n",the_str);
			}
		}
		else
		{
			printf("Using Undefined Function '%s'\n",$2);
			next_line = onerror;
		}
//printf("REPL: '%s'\n",fn -> fnline -> the_str);
		$$ = 1;
	}
|
	Len '(' string_expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: LEN(string_expr)\n");
#endif
		$$ = strlen($3);
	}
|
	Peek '(' expr ')'
	{
#ifdef DEBUGEXPR
printf(" *-* expr: PEEK(expr)\n");
#endif
		$$ = 0;
	}

string_expr:
	STRING
|
	string_variable
	{
		strcpy($$,$1 -> svalue);
	}
|
	Mid '(' string_expr ',' expr ')'
	{
		if ($5 <= strlen($3))
		{
			strcpy($$,$3 + (int)$5 - 1);
		}
		else
			*$$ = 0;
	}
|
	Mid '(' string_expr ',' expr ',' expr ')'
	{
		if ($5 <= strlen($3))
		{
			strcpy($$,$3 + (int)$5 - 1);
			$$[ (int)$7] = 0;
		}
		else
			*$$ = 0;
	}
|
	Left '(' string_expr ',' expr ')'
	{
		if ($5 > 0)
		{
			strncpy($$,$3, (int)$5);
			$$[(int)$5] = 0;
		}
	}
|
	Right '(' string_expr ',' expr ')'
	{
		if (strlen($3) > $5)
			strcpy($$,$3 + strlen($3) - (int)($5 + 0.01));
		else
			strcpy($$,$3);
	}
|
	Chr '(' expr ')'
	{
		*$$ = (char)$3;
		$$[1] = 0;
	}
|
	string_expr '+' string_expr
	{
		sprintf($$,"%s%s",$1,$3);
	}
|
	Str '(' expr ')'
	{
		sprintf($$,"%f",$3);
		while ($$[strlen($$) - 1] == '0')
			$$[strlen($$) - 1] = 0;
		if ($$[strlen($$) - 1] == '.')
			$$[strlen($$) - 1] = 0;
	}
|
	Tab '(' expr ')'
	{
		*$$ = 0;
		while (tab_pos < $3)
		{
			strcat($$," ");
			tab_pos++;
		}
	}
|
	Spc '(' expr ')'
	{
		*$$ = 0;
		for (i = 0; i < $3; i++)
			strcat($$," ");
	}

int_list:
	NUM
	{
		$$.qty = 0;
		$$.values[$$.qty++] = (long)$1;
	}
|
	int_list ',' NUM
	{
		$$ = $1;
		$$.values[$$.qty++] = (long)$3;
	}

var_list:
	variable
	{
		$$.qty = 0;
		$$.var[$$.qty++] = $1;
	}
|
	string_variable
	{
		$$.qty = 0;
		$$.var[$$.qty++] = $1;
	}
|
	var_list ',' variable
	{
		$$ = $1;
		$$.var[$$.qty++] = $3;
	}
|
	var_list ',' string_variable
	{
		$$ = $1;
		$$.var[$$.qty++] = $3;
	}

variable:
	NUMVAR
	{
		$$ = reg_variable($1,NULL);
	}
|
	IDENTIFIER
	{
		$$ = reg_variable($1,NULL);
	}
|
	NUMVAR '(' expr_list ')'
	{
		$$ = reg_variable($1,&$3);
	}
|
	IDENTIFIER '(' expr_list ')'
	{
		$$ = reg_variable($1,&$3);
	}

string_variable:
	STRINGVAR
	{
		$$ = reg_variable($1,NULL);
#ifdef DEBUG
printf("%s = '%s'\n",$$ -> name,$$ -> svalue);
#endif
	}
|
	STRINGVAR '(' expr_list ')'
	{
		$$ = reg_variable($1,&$3);
#ifdef DEBUG
printf("%s(",$$ -> name);
for (i = 0; i < $$ -> qindex; i++)
	printf("%s%d",i ? "," : "",$$ -> index[i]);
printf(") = '%s'\n",$$ -> svalue);
#endif
	}

%%


VARIABLE *reg_variable(char *name,EXPRLIST *p)
{
	VARIABLE *v;
	int i;
	char type[2];

//printf(" ### variablebase %lx\n",(long)variablebase);

	if (*name != '$') // not a function (def fn)
	{
		switch (name[strlen(name) - 1])
		{
		case '$':
			strcpy(type,"$");
			name[strlen(name) - 1] = 0;
			break;
		case '%':
			strcpy(type,"%");
			name[strlen(name) - 1] = 0;
			break;
		default:
			*type = 0;
		}
		name[2] = 0;
		strcat(name,type);
	}

	if (p)
	{
		strcat(name,"(");
		for (i = 0; i < p -> qty; i++)
		{
			if (i)
				strcat(name,",");
			sprintf(name + strlen(name),"%d",(int)(p -> values[i] + 0.01));
		}
		strcat(name,")");
	}

	for (v = variablebase; v; v = v -> next)
	{
		if (!strcmp(v -> name,name))
			break;
	}
	if (!v)
	{
		v = (VARIABLE *)malloc(sizeof(VARIABLE));
		if (!v)
		{
			printf("malloc failed\n");
			exit(-1);
		}
		strcpy(v -> name,name);
		v -> ivalue = 0;
		v -> value = v -> fnvalue = 0;
		*v -> svalue = 0;
		v -> next = variablebase;
		variablebase = v;
	}
	return v;
}

void text_output(char *s)
{
	char *cmd;
	char *arg;
	char *option;
	long offset;
	int i;
	short cmnum;

	if (*s == 4)	// CHR$(4) - dos command
	{
		if (s[strlen(s) - 1] == '\n');
			s[strlen(s) - 1] = 0;
		file_read = 0;
		file_write = 0;
		fil = NULL;
		cmd = strtok(s + 1," ");
		if (!cmd)
		{
#ifdef DEBUG
			printf(" * Empty CHR$(4)\n");
#endif
			return;
		}
		arg = strtok(NULL,",");
#ifdef DEBUG
printf(" * file command '%s' argument '%s'\n",cmd,arg);
#endif
		if (!strcmp(cmd,"RUN"))
			cmnum = 1;
		else
		if (!strcmp(cmd,"OPEN"))
			cmnum = 2;
		else
		if (!strcmp(cmd,"CLOSE"))
			cmnum = 3;
		else
		if (!strcmp(cmd,"READ"))
			cmnum = 4;
		else
		if (!strcmp(cmd,"WRITE"))
			cmnum = 5;
		else
		if (!strcmp(cmd,"DELETE"))
			cmnum = 6;
		else
		{
			printf("##############################################\n");
			printf("#### implement dos command\n");
			printf("####  cmd '%s' arg '%s'\n",cmd,arg);
			printf("##############################################\n");
			cmnum = 0;
		}

		option = strtok(NULL,",");
		option_s = -1;
		option_d = -1;
		option_l = -1;
		option_r = -1;
		while (option)
		{
#ifdef DEBUG
printf("   option '%s'\n",option);
#endif
			switch (*option)
			{
			case 'S':
				option_s = atoi(option + 1);
				break;
			case 'D':
				option_d = atoi(option + 1);
				break;
			case 'L':
				option_l = atoi(option + 1);
				break;
			case 'R':
				option_r = atoi(option + 1);
				break;
			default:
				printf("####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
				printf("##############################################\n");
			}
			option = strtok(NULL,",");
		}

		if (!running)
			return;

		switch (cmnum)
		{
		case 1: // run
			printf(" * RUN '%s'\n",arg);
			strcpy(run_program,arg);
			next_line = NULL;
			break;
		case 2: // open ,S ,D ,L
			for (o = openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (o)
			{
//				printf(" *** FILE already OPEN\n");
			}
			else
			{
				o = (OPEN *)malloc(sizeof(OPEN));
				o -> fil = fopen(arg,"r+b");
				if (!o -> fil)
					o -> fil = fopen(arg,"w+b");
				if (!o -> fil)
				{
					printf(" *** OPEN '%s' failed\n",arg);
					next_line = onerror;
					free(o);
				}
				else
				{
					strcpy(o -> name,arg);
					stat(arg,&o -> file_stat);
					o -> option_s = option_s;
					o -> option_d = option_d;
					o -> option_l = option_l;
					o -> option_r = 0;
					addlist(&openbase,o);
				}
			}
			break;
		case 3: // close
			if (arg)
			{
				for (o = openbase; o; o = o -> next)
					if (!strcmp(o -> name,arg))
						break;
				if (!o)
					printf(" *** FILE not OPEN (CLOSE)\n");
				else
				{
					fclose(o -> fil);
					removelist(&openbase,o);
					free(o);
				}
			}
			else
			{
				while (openbase)
				{
					o = openbase;
					fclose(o -> fil);
					removelist(&openbase,o);
					free(o);
				}
			}
			break;
		case 4: // read ,R
			for (o = openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				printf(" *** FILE not OPEN (READ)\n");
			else
			{
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
					if (offset > o -> file_stat.st_size)
						next_line = onerror;
//					printf(" * READ '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
					if (fseek(o -> fil,offset,SEEK_SET))
						next_line = onerror;
				}
				file_read = 1;
				fil = o -> fil;
			}
			break;
		case 5: // write ,R
			for (o = openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				printf(" *** FILE not OPEN (WRITE)\n");
			else
			{
#ifdef DEBUG
printf(" * Write to file '%s'\n",o -> name);
#endif
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
#ifdef DEBUG
					printf(" * WRITE '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
#endif
					if (fseek(o -> fil,offset,SEEK_SET))
						next_line = onerror;
				}
				file_write = 1;
				fil = o -> fil;
#ifdef DEBUG
printf(" * ...\n");
#endif
			}
			break;
		case 6: // delete
			unlink(arg);
			break;

		default:
			break;
		} // switch (cmnum)

	}
	else
	{
		if (!running)
			return;

		if (fil && file_write)
		{
			if (s[strlen(s) - 1] == 0x0a)
				s[strlen(s) - 1] = 0x8d;
			fwrite(s,strlen(s),1,fil);
		}
		else
		{
			i = 0;
			while (s[i])
			{
				if (strlen(s + i) > 40)
				{
					strncpy(slask,s + i,40);
					slask[40] = 0;
					printf("%s\n",slask);
					i += 40;
				}
				else
				{
					printf("%s",s + i);
					i += strlen(s + i);
				}
				fflush(stdout);
			}
		}
	}
}

void file_input(char *s,int l)
{
	int i = 0;
	short q = 0;
	unsigned char c;

	if (fil)
		fread(&c,1,1,fil);
	while (fil && !feof(fil) && c != 0x8d && (q || (c & 0x7f) != ',') && c)
	{
		if (i >= l - 1)
		{
			printf(" ********* BUFFER OVERFLOW ********\n");
			s[l - 1] = 0;
			printf("%s\n",s);
			exit(-1);
		}
		s[i++] = c & 0x7f;
		if ( (c & 0x7f) == 34)
			q = !q;
#ifdef DEBUG
printf("%c",c & 0x7f);
#endif
		fread(&c,1,1,fil);
	}
	s[i] = 0;
	if (*s == 34 && s[strlen(s) - 1] == 34)
	{
		memmove(s,s + 1,strlen(s) + 1);
		s[strlen(s) - 1] = 0;
	}
#ifdef DEBUG
printf("\n");
#endif
}

void file_init(void)
{
	fil = NULL;
	onerror = NULL;
	current_data = database;
	dataptr = 0;
}

#define DC (current_data?current_data->data[dataptr]:0)

void get_data(char *s)
{
	int x = 0;

	while (DC == ' ' || DC == 9)
		dataptr++;
	if (!DC)
	{
		current_data = current_data ? current_data -> next : NULL;
		dataptr = 0;
		while (DC == ' ' || DC == 9)
			dataptr++;
	}
	if (DC)
	{
		while (DC && DC != ',')
		{
			s[x++] = DC;
			dataptr++;
		}
		if (DC == ',')
			dataptr++;
	}
	s[x] = 0;
}

void read_data(VARLIST *vl)
{
	int i;

	for (i = 0; i < vl -> qty; i++)
	{
		get_data(vl -> var[i] -> svalue);
		vl -> var[i] -> value = atof(vl -> var[i] -> svalue);
	}
}

